/*
 * Copyright (c) 2019 Amazon.com, Inc. or its affiliates.  All rights
 * reserved.
 *
 * This software is licensed under the terms of the GNU General Public
 * License version 2, as published by the Free Software Foundation, and
 * may be copied, distributed, and modified under those terms.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/u64_stats_sync.h>
#include "amazon_net.h"

static struct net_device  *loop_device;

static int loop_amazon_sdio_xmit(struct net_device *ndev, struct sk_buff *skb)
{
	return amazon_net_receive(ndev, skb);
}

static int loop_amazon_sdio_init(void)
{
	pr_info("%s\n", __func__);

	loop_device = amazon_net_ndev_create(0, &loop_ops, "amazon_loop");
	return  (loop_device) ? 0 : -1;
}

static void loop_amazon_sdio_deinit(void)
{
	amazon_net_ndev_delete(loop_device);
}

const struct amazon_net_ops loop_ops = {
		.xmit = loop_amazon_sdio_xmit,
		.init = loop_amazon_sdio_init,
		.deinit = loop_amazon_sdio_deinit,
		.select_queue = NULL,
		.do_ioctl = NULL
};

